/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.sensor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.internal.DefaultSensorDescriptor;
import org.sonar.api.resources.Project;
import org.sonarsource.sonarlint.core.analyzer.sensor.SensorOptimizer;

public class SensorWrapper
implements org.sonar.api.batch.Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(SensorWrapper.class);
    private Sensor wrappedSensor;
    private SensorContext adaptor;
    private DefaultSensorDescriptor descriptor;
    private SensorOptimizer optimizer;

    public SensorWrapper(Sensor newSensor, SensorContext adaptor, SensorOptimizer optimizer) {
        this.wrappedSensor = newSensor;
        this.optimizer = optimizer;
        this.descriptor = new DefaultSensorDescriptor();
        newSensor.describe(this.descriptor);
        this.adaptor = adaptor;
    }

    public Sensor wrappedSensor() {
        return this.wrappedSensor;
    }

    @Override
    public boolean shouldExecuteOnProject(Project project) {
        return this.optimizer.shouldExecute(this.descriptor);
    }

    @Override
    public void analyse(Project module, org.sonar.api.batch.SensorContext context) {
        this.wrappedSensor.execute(this.adaptor);
    }

    public String toString() {
        return this.descriptor.name() + (LOG.isDebugEnabled() ? " (wrapped)" : "");
    }
}

